#*****************************************************************************
#  This sample is supplied as is with no implied warranty.  
#  It is designed to assist you in using the Cisco AnyConnect VPN API. 
#  It is assumed that you will build a production application and 
#  refer to this sample as a reference only.
#*****************************************************************************
CXX = g++
CXXFLAGS = -DHAVE_CONFIG_H -D_NOEXPORTDLL -g -O0 -Wall ${INCLUDES}
INCLUDES = -I. -I../../include -I/usr/include/libxml2
LIB_DIR = ../../lib/Linux/Intel_64
CURL_VER = 4.5.0
LIBS = -lvpnapi -lrt -lz -lvpncommoncrypt -lvpncommon -lpthread -lacciscocrypto -lacciscossl -lxml2 -ldl `pkg-config --libs gio-2.0`
LDFLAGS = -g
DYLIB_DIR = /opt/cisco/anyconnect/lib

all: client client_so

client: CLIClientMain.o CLIClientImpl.o
	@echo "\nLinking using static libs..."
	${CXX} ${CXXFLAGS} ${LDFLAGS} ${INCLUDES} -L${LIB_DIR} \
	-o client CLIClientMain.o CLIClientImpl.o \
	${LIBS} -laccurl -Wl,-rpath=$(CURDIR)/${LIB_DIR}

client_so: CLIClientMain.o CLIClientImpl.o
	@echo "\nLinking using dynamic libs..."
	${CXX} ${CXXFLAGS} ${LDFLAGS} ${INCLUDES} -L${DYLIB_DIR} \
	-o client_dylib CLIClientMain.o CLIClientImpl.o \
	${LIBS} ${DYLIB_DIR}/libaccurl.so.${CURL_VER} -Wl,-rpath=${DYLIB_DIR}


clean:
	rm -f *.o client client_so
