/**************************************************************************
*       Copyright (c) 2008, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    PreferenceInfoBase.h
*  Date:    7/2008
*
***************************************************************************
*
*   Preference Info Base class declaration for the Client API.
*
***************************************************************************/

// The PreferenceInfoBase class contains the majority of private methods and 
// members. The purpose of this class is to hide all but the necessary methods 
// from being exposed.
//

#ifndef _PREFERENCEINFOBASE_
#define _PREFERENCEINFOBASE_

#include "api.h"
#include <vector>
#include <list>
#include <map>

class Preference;
class PreferenceInfo;

typedef std::vector<Preference*> PreferenceVector;
typedef std::map<PreferenceId, unsigned int> PreferencePositionMap;
typedef std::map<PreferenceId, Preference*> PreferencePointerMap;

typedef std::pair<Preference *, unsigned int> PrefWithDepth;
typedef std::list<PrefWithDepth> PrefWithDepthList;


class VPN_VPNAPI PreferenceInfoBase
{
    protected:

        PreferenceInfoBase();

    public:

        PreferenceScope getPreferencesType() const;
        void setPreferencesType(const PreferenceScope scope);

        unsigned int countPreferences() const;

        static PreferenceInfo* createDefaultPreferenceInfo();

        const PreferenceVector& getListPreferences() const;

        PreferenceVector getAllPreferences() const;
		
		void getAllPreferencesSorted(OUT PrefWithDepthList &outSortedPrefs) const;
		
        bool getPreference(const PreferenceId preferenceId, 
                           OUT Preference*& rpPreference) const;

        bool addPreference(Preference* pPreference);
        bool addNewPreference(const tstring& name,
                              const tstring& value,
                              ApiStringMap& attributes,
                              const tstring& parent = EmptyString);
        bool movePreference(Preference* pPreference, unsigned int& position);

        bool removeAndDeletePreference(const PreferenceId& preferenceId, bool bDontRemoveFromParent = false);
        void removeAllPreferences();

        void setPreferenceHeading(const tstring& preferenceHeading);
        const tstring getPreferenceHeading() const;

        PreferenceInfoBase& operator=(const PreferenceInfoBase& assignmentOperator);
        explicit PreferenceInfoBase(const PreferenceInfoBase&);
        ~PreferenceInfoBase();

        tstring getString();

    private:

        PreferenceVector m_ParentPreferenceVector; 
        PreferencePositionMap mem_PreferencePositionMap;
        PreferencePointerMap mem_PreferencePointerMap; 
        PreferenceScope m_PreferenceScope;
        tstring m_preferenceHeading;

        static tstring EmptyString;

};


#endif // _PREFERENCEINFOBASE_
